/*****************************
	Weather 5.0.2
	Maxthon Sidebar Plugin
	By Neo101
******************************/

var CONFIG_WIDTH = '300'
var CONFIG_HEIGHT = '400'

var SUPPORT_URL = 'http://forum.maxthon.com/index.php?showtopic=33672'
/*
function expandCollapse( element ){
	var nextElement = element.nextSibling
	var itemName = 'Display' + nextElement.id.replace(/data/,'')
	if(nextElement.style.display == 'none'){
		nextElement.style.display = 'block'
		writeSetting(itemName, '1')
	}
	else{
		nextElement.style.display = 'none'
		writeSetting(itemName, '0')
	}
	
}*/


function changeCity(number){
	document.getElementById('error').innerHTML = ''
	var items = ['dataNow', 'dataToday', 'dataTonight', 'dataTodayDetailed', 'dataFuture']
	for(var i=0; i<items.length; i++){
		document.getElementById( items[i] ).innerHTML = translate('loading')
	}
	document.getElementById('cityLink'+activeCity).style.fontWeight = 'normal'
	document.getElementById('cityLink'+number).style.fontWeight = 'bold'
	
	locationId = readSetting('LocationCode' + number)
	cityName = transLocation( readSetting('LocationTxt' + number) )
	writeSetting('ActiveCity', number)
	activeCity = number
	
	setLocation(cityName)
	
	if(showLastUpdate != '0')
		document.getElementById('updateTime').innerHTML = ''
	
	if(showDetailsLink != '0')
		document.getElementById('moreDetails').href = detailsLink + locationId
	
	loadWeatherData()
}


function setStates(){
	var items = ['DisplayNow', 'DisplayToday', 'DisplayTonight', 'DisplayTodayDetailed', 'DisplayFuture', 'DisplayMenu']
	var elements = ['dataNow', 'dataToday', 'dataTonight', 'dataTodayDetailed', 'dataFuture', 'menu']
	for(var i=0; i<items.length; i++){
		var style = document.getElementById( elements[i] ).style
		if(readSetting( items[i] ) == '1'){
			style.display = 'block'
		}
		else{
			style.display = 'none'
		}
	}
}


function blurLinks(){
	var links = document.getElementsByTagName('a')
	for(var i=0; i<links.length; i++){
		links[i].onfocus = function(){
								this.blur()
							}
	}
}


function writeCities(){
	var result = ''
	for(var i=1; i<=numberOfCities; i++){
		var location = transLocation( readSetting('LocationTxt' + i) )
		result += '<td><a title="'+location+'" id="cityLink'+i+'" href="javascript:changeCity('+i+')">'+i+'</a></td>'
	}
	document.write( result )
}


function writeAboutBox(){
	var text = ''
	if(showLastUpdate != '0')
		text += '<span id=updateTime>?</span><br>'
	if(showDetailsLink != '0')
		text += '<a href="'+ detailsLink + locationId +'" target=_blank id=moreDetails>'+translate('MoreDetails')+'</a><br>'
	text +=	'<span onclick="window.open(\''+SUPPORT_URL+'\')" style="cursor:hand">'+
                'Weather ' + VERSION + 
            '</span> - '+
			'<nobr>'+translate('By')+' <span onclick="window.open(\'http://www.neo101.nl/\')" style="cursor:hand">Neo101</span></nobr><br>'+
			translate('ByWeatherCom')+' <br>'
	
	document.write(text)
}


function writeNewUserMessage(){
	var element = document.getElementById('newUserMessage')
	var text = translate('newUserMessage')
	element.innerHTML = text + '&nbsp;&nbsp;&nbsp;<a href="javascript:void(0)" onclick="this.parentElement.style.display=\'none\'">X</a>'
	element.style.display = ''
}


function setLocation( location ){
	document.getElementById('location').innerHTML = location
}


function writeCityName(){
	document.write('<span title="' + translate('cityTooltip') + '">' + cityName + '</span>')
}


function showConfig(){
	var left = ( screen.width/2 ) - ( CONFIG_WIDTH / 2 )
	var top =  ( screen.height/2 ) - ( CONFIG_HEIGHT / 2 )
	var list = 'status:0;help:0;scroll:0;resizable:0;dialogHeight:'+CONFIG_HEIGHT+'px;dialogWidth:'+CONFIG_WIDTH+
					'px;center:0;dialogLeft:'+left+'px;dialogTop:'+top+'px'
	var dialog = window.showModalDialog('configuration.html', window, list)
}


function configClose(isChanged){
	if(isChanged == true)
		location.reload()
}


//Expand / Collapse animation


var TIMEOUT_TIME = 15
var STEP_SIZE = 6


function expandCollapse(element){
	var elementId = element.nextSibling.id
	var element = document.getElementById(elementId)
	var itemName = 'Display' + elementId.replace(/data/,'')
	if(useAnimation == '1'){
		if(element.offsetHeight < 1){
			element.style.filter = "alpha(opacity=0)";
			element.style.display = 'block'
			window.setTimeout('increaseHeight("'+elementId+'")',TIMEOUT_TIME)
			writeSetting(itemName, '1')
		} else {
			window.setTimeout('decreaseHeight("'+elementId+'")',TIMEOUT_TIME)
			writeSetting(itemName, '0')
		}
	} else {
		if(element.style.display == 'none'){
			element.style.display = 'block'
			writeSetting(itemName, '1')
		}
		else{
			element.style.display = 'none'
			writeSetting(itemName, '0')
		}
	}
}


function increaseHeight(elementId){
	var element = document.getElementById(elementId)
	var currentHeight = returnHeight(element)
	var step = element.scrollHeight / STEP_SIZE
	var newHeight = currentHeight + step
	if(newHeight <= element.scrollHeight){
		element.style.height = newHeight + 'px'
		window.setTimeout('increaseHeight("'+elementId+'")', TIMEOUT_TIME)
	} else {
		element.style.height = ''
	}
	changeOpacity(element, currentHeight)
}


function decreaseHeight(elementId){
	var element = document.getElementById(elementId)
	var currentHeight = returnHeight(element)
	var step = element.scrollHeight / STEP_SIZE
	var newHeight = currentHeight - step
	if(newHeight > 1){
		element.style.height = newHeight + 'px'
		window.setTimeout('decreaseHeight("'+elementId+'")', TIMEOUT_TIME)
	} else {
		element.style.display = 'none'
	}
	changeOpacity(element, currentHeight)
}


function returnHeight(element){
	var height = element.style.height.replace(/\D+/g,'') * 1 //convert string to number
	if(height == ''){
		height = element.scrollHeight
		element.style.height = height + 'px'
	}
	return height
}


function changeOpacity(element, currentHeight){
	var percentDone = currentHeight / element.scrollHeight * 100
	element.style.filter = "alpha(opacity=" + percentDone + ")";
}
